<?php
/**
 * The template for displaying product category thumbnails within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product-cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// Grid variables

$columns = get_theme_mod( 'calafate_shop_columns', '3' ); 
$portfolio_type = get_theme_mod( 'calafate_shop_style', 'Flexible' );
$project_size = 1;

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'product_cat entry-portfolio uninit ' . $category->slug . ' hover-' . get_theme_mod( 'calafate_shop_hover', 'one' ) ); ?> data-size="<?php echo $project_size; ?>">

	<?php // We decided to remove all hooks because we don't want any plugin to play with our theme's design. ?>

	<div class="entry-info">

		<a class="entry-title poppins ajax-link" href="<?php echo get_term_link( $category->slug, 'product_cat' ); ?>">
			<h3><?php
				echo $category->name; 
				echo apply_filters( 'woocommerce_subcategory_count_html', ' <span>(' . $category->count . ')</span>', $category );
			?></h3>
		</a>
		
		<div class="entry-buttons" style="margin-left: -40px;">

			<a class="ajax-link" href="<?php echo get_term_link( $category->slug, 'product_cat' ); ?>"><?php echo calafate_svg( 'eye' ); ?></a>

		</div>

	</div>

	<figure class="entry-thumbnail">

		<?php 

			$thumb = get_term_meta( $category->term_id, 'thumbnail_id', true );

			if ( $thumb != '' ) {
				$image = wp_get_attachment_image_src( $thumb, 'full' )[0];
				$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image );
			} else {
 				$image = get_template_directory_uri() . '/images/blank-product.jpg';
				$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image, 1600, 1600 );
			}

		?>	

		<div class="entry-thumbnail-holder" style="padding-top: <?php echo floatval( $img[2] ); ?>%" data-padding="<?php echo floatval( $img[2] ); ?>">
						
			<img class="primary lazyload" data-srcset="<?php echo esc_attr( $img[0] ); ?>" srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="<?php echo esc_url( $img[1] ); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" data-sizes="auto" />

			<?php 

				$image = wp_get_attachment_url( get_post_meta( $post->ID, 'portfolio_featured-thumbnail-secondary_thumbnail_id', true ) );

				if ( isset( $image ) && $image != '' ) :

					$img = calafate_portfolio_images( $portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image );

				?>

					<img class="secondary lazyload" data-srcset="<?php echo esc_attr( $img[0] ); ?>" srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="<?php echo esc_url( $img[1] ); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" data-sizes="auto" />

				<?php endif; 

			?>

		</div>
	
	</figure>

</article>
